<%@ Page Language="C#" %>

<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        RangeValidator1.MinimumValue = DateTime.Now.ToShortDateString();
        RangeValidator1.MaximumValue = DateTime.Now.AddDays(14).ToShortDateString();
    }

    protected void Calendar1_SelectionChanged(object sender, EventArgs e)
    {
        TextBox1.Text = Calendar1.SelectedDate.ToShortDateString();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        if (Page.IsValid) 
        {
            Label1.Text = "Data przybycia ustawiona jest na: " + TextBox1.Text.ToString();
        }
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>Sprawdzenie poprawnoci daty</title>
</head>
<body>
    <form id="form1" runat="server">
        Data przyjazdu:
        <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>&nbsp;
        <asp:RangeValidator ID="RangeValidator1" runat="server" 
         Text="Mona wybra dat tylko na dwa tygodnie do przodu." 
         ControlToValidate="TextBox1" Type="Date"></asp:RangeValidator><br />
        <br />
        Wybierz dat przyjazdu:<br />
        <asp:Calendar ID="Calendar1" runat="server" 
         OnSelectionChanged="Calendar1_SelectionChanged"></asp:Calendar>
        &nbsp;
        <br />
        <asp:Button ID="Button1" runat="server" Text="Przycisk" 
         OnClick="Button1_Click" />
        <br />
        <br />
        <asp:Label ID="Label1" runat="server"></asp:Label>        
    </form>
</body>
</html>
